//The XC3804 sets up an AP with these credentials:
#define STASSID "Duinotech WiFi Relay"
#define STAPSK NULL
//at this server/port
const char* host = "relay.net";
const uint16_t port = 80; //well known http port

const char* ssid = STASSID;
const char* password = STAPSK;
const char openURL[]="http://relay.net/open";
const char closeURL[]="http://relay.net/close";

#if defined(ESP8266)
//for ESP8266:
#include <ESP8266WiFi.h>
#include <ESP8266WiFiMulti.h>
#include <WiFiClient.h>
#include <ESP8266HTTPClient.h>
ESP8266WiFiMulti multi;
WiFiClient client;
#define SOFTRESTART() ESP.restart()
char buf[64]="";
HTTPClient http;
#define HTTPBEGIN(x) http.begin(client,x)
#endif

#if defined(ARDUINO_ARCH_RP2040)
//for Pico:
#include <WiFi.h>
WiFiMulti multi;
#define SOFTRESTART() rp2040.reboot()
#include <HTTPClient.h>
HTTPClient http;
#define HTTPBEGIN(x) http.begin(x)
#endif


void setup() {
  int c;
  Serial.begin(115200);
  while(!Serial && millis()<5000){}   //wait for serial with timeout
  Serial.println("Starting");
  c = WiFi.scanNetworks();
  if (!c) {
    Serial.printf("No networks found\n");
  } else {
    Serial.printf("Found %d networks\n\n", c);
    Serial.printf("%32s %2s %4s\n", "SSID", "CH", "RSSI");
    for (int i = 0; i < c; i++) {
#if defined(ESP8266)
      WiFi.SSID(i).toCharArray(buf,60);
      Serial.printf("%32s %2d %4ld\n",buf, WiFi.channel(i), WiFi.RSSI(i));
#endif
#if defined(ARDUINO_ARCH_RP2040)
      Serial.printf("%32s %2d %4ld\n", WiFi.SSID(i), WiFi.channel(i), WiFi.RSSI(i));
#endif
    }
  }
    WL_IDLE_STATUS;
  multi.addAP(ssid, password);
  if (multi.run() != WL_CONNECTED) {
    Serial.printf("Status:%d\r\n",WiFi.status());
    Serial.println("Unable to connect to network, rebooting in 5 seconds...");
    delay(5000);
    SOFTRESTART();
  }
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());    
  Serial.println("Type 0 (open) or 1 (close) to set relay.");
}

void loop() {
  int d=0;
  static int cmd=0;
  int state=0;
  int httpcode=0;
  if(Serial.available()){
    d=Serial.read();
    if(d=='0'){
      Serial.println("Opening.");
      cmd='0';
    }else if(d=='1'){
      Serial.println("Closing.");
      cmd='1';
    }
  }
  if((cmd=='0')||(cmd=='1')){
    if(cmd=='0'){
      state=HTTPBEGIN(openURL);
      Serial.printf("Requesting %s\r\n",openURL);
    }else{
      state=HTTPBEGIN(closeURL);
      Serial.printf("Requesting %s\r\n",closeURL);
    }
    if(state){
      httpcode=http.GET();
      Serial.printf("HTTP code %d received.\r\n",httpcode);
      if(httpcode==HTTP_CODE_OK){
        cmd=0;      //done
        Serial.println("Command done.");
      }
    }else{
      Serial.println("Cannot connect to server.");
    }
    http.end();
  }  
  delay(100);
}
